<?php
$input = $_GET['q'] ?? '';

function weak_filter($data) {
    // ❌ blacklist debole (tipico errore)
    $blocked_tags = [
        'script',
        'img',
        'iframe'
    ];

    $blocked_events = [
        'onerror',
        'onclick',
        'onload'
    ];

    $blocked_words = [
        'alert'
    ];

    foreach ($blocked_tags as $tag) {
        $data = str_ireplace($tag, '', $data);
    }

    foreach ($blocked_events as $event) {
        $data = str_ireplace($event, '', $data);
    }

    foreach ($blocked_words as $word) {
        $data = str_ireplace($word, '', $data);
    }

    return $data;
}

$filtered = weak_filter($input);
?>

<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>XSS Challenge</title>
</head>
<body>

<h1>XSS Challenge</h1>

<p>
    Obiettivo: eseguire <code>alert(1)</code><br>
    Filtri attivi:
</p>

<ul>
    <li>Tag bloccati: <code>script</code>, <code>img</code>, <code>iframe</code></li>
    <li>Eventi bloccati: <code>onerror</code>, <code>onclick</code>, <code>onload</code></li>
    <li>Parola bloccata: <code>alert</code></li>
</ul>

<hr>

<form method="GET">
    <input type="text" name="q" size="80" placeholder="Inserisci payload">
    <button type="submit">Invia</button>
</form>

<hr>

<h2>Output:</h2>
<div style="border:1px solid black; padding:10px;">
    <?php
        // ❌ output non sanitizzato
        echo $filtered;
    ?>
</div>

</body>
</html>
