<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <title>XSS Demo</title>
</head>
<body>

<h1>Dimostrazione XSS</h1>

<!-- ===================== -->
<!-- 1) REFLECTED XSS -->
<!-- ===================== -->
<h2>1) Reflected XSS</h2>

<p>
    L’input viene riflesso direttamente nella risposta.
    <br>
    Prova a inserire:
    <code>&lt;script&gt;alert(1)&lt;/script&gt;</code>
</p>

<form method="GET">
    <input type="text" name="reflected">
    <button type="submit">Invia</button>
</form>

<p>Output:</p>
<div style="border:1px solid black; padding:5px;">
<?php
if (isset($_GET['reflected'])) {
    // ❌ VULNERABILE: input riflesso senza sanitizzazione
    echo $_GET['reflected'];
}
?>
</div>

<hr>

<!-- ===================== -->
<!-- 2) STORED XSS -->
<!-- ===================== -->
<h2>2) Stored XSS</h2>

<p>
    L’input viene salvato e rieseguito ad ogni visita.
    <br>
    Prova:
    <code>&lt;script&gt;alert(1)&lt;/script&gt;</code>
</p>

<form method="POST">
    <input type="text" name="stored">
    <button type="submit">Salva</button>
</form>

<p>Output persistente:</p>
<div style="border:1px solid black; padding:5px;">
<?php
$file = "stored.txt";

if (isset($_POST['stored'])) {
    // ❌ VULNERABILE: salvataggio diretto
    file_put_contents($file, $_POST['stored']);
}

if (file_exists($file)) {
    // ❌ VULNERABILE: esecuzione payload persistente
    echo file_get_contents($file);
}
?>
</div>

</body>
</html>
